/*------------------------------------------------------------------------------*
 * File Name: TwoGraphDlg.h				 										*
 * Creation: 																	*
 * Purpose: CTwoDialog class									 				*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <Project.h>    
#include <Graph.h> 
#include <Dialog.h> 
#include "Graphs.h"      // Resource IDs, in same location as this C file

class CTwoDialog : public Dialog
{
public:
	CTwoDialog() : Dialog("TwoGraphs", "Graphs")
	{
		
	}
	//virtual 
	int  DoModal(HWND hParent = NULL)
	{
		InitMsgMap();
		int nRet = Dialog::DoModal(hParent);//Launch the dialog
		return nRet;
	}	
	
protected:
	
EVENTS_BEGIN
	ON_INIT( OnInitDialog ) 
	ON_SIZE( OnDlgResize )
EVENTS_END		

	// *** Add plot to GraphControl ***
	bool PlotToGraphControl( GraphControl& ogc, Curve& cuv, bool bRescaleAll = true )
	{
		GraphPage gp = ogc.GetPage(); // Get page
		GraphLayer gl = gp.Layers();  // Get active layer
		
		if( gl.AddPlot( cuv ) < 0 )   // Plot curve in GraphControl
			return false;
		
		if( bRescaleAll )             // Rescale layer
			gl.Rescale();
		
		return true;
	}
		
	// *** Initialize Dialog on creation ***
	BOOL OnInitDialog()
	{
		// initialize all data members of interface control
		m_btnOK = GetItem( IDOK );
		
		m_gpControl1 = GetItem( IDC_TWOGRAPHS_GRAPH1 );
		
		m_gpControl2 = GetItem( IDC_TWOGRAPHS_GRAPH2 );
		
		// Create Origin graph and add to first GraphControl
		m_gpControl1.Create( NOCLICK_AXES | NOCLICK_TICKLABEL | NOCLICK_LAYERICON | NOCLICK_DATA_PLOT );
		Worksheet wks = Project.ActiveLayer();
		Curve cc1( wks, 0, 1 ); 
		PlotToGraphControl( m_gpControl1, cc1 );
	
		// Create Origin graph and add to second GraphControl
		m_gpControl2.Create( NOCLICK_AXES | NOCLICK_TICKLABEL | NOCLICK_LAYER ); // Only disable clicking on axis related objects
		Curve cc2( wks, 0, 2 );
		PlotToGraphControl( m_gpControl2, cc2 );
		return true;
	}
	
	// *** Re-size controls on re-sized Dialog ***
	// nType = SIZE_MAXIMIZED, SIZE_RESTORED etc, can be ignored
	// cx and cy are width and height of dialog   
	BOOL OnDlgResize( int nType, int cx, int cy )
	{
		
		// Re-position Close (OK) button
		RECT r1, r2;
		m_btnOK.GetWindowRect( &r1 );
		int nButtonWidth = r1.right - r1.left;
		int nButtonHeight = r1.bottom - r1.top;
		int nCloseButtonGap = nButtonHeight + 3; // Extra 3 pixel from bottom of dialog
		r1.left = cx/2 - nButtonWidth/2;
		r1.right = cx/2 + nButtonWidth/2;
		r1.top = cy - nCloseButtonGap;
		r1.bottom = r1.top + nButtonHeight;
		m_btnOK.MoveWindow( &r1 );	
		
		// Re-size GraphControls
		// Place GraphControls side by side and leave some space for Close button
		int nBottom = cy - nCloseButtonGap - 4; // Extra 4 pixcels between bottom of graph and Close button
		r1.left = 0, r1.top = 0, r1.right = cx / 2 - 1, r1.bottom = nBottom;
		r2.left = cx / 2 + 1, r2.top = 0, r2.right = cx, r2.bottom = nBottom; 
		m_gpControl1.MoveWindow( &r1 );
		m_gpControl2.MoveWindow( &r2 );
		
		return TRUE;
	}
	
private:
	Button			m_btnOK;		// OK button control
	GraphControl	m_gpControl1;
	GraphControl	m_gpControl2;
};
